
<?php
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(32767);

// Conexão com banco
$db = new SQLite3("./api/.ansdb.db");
$db->exec("
    CREATE TABLE IF NOT EXISTS ibo(
        id INTEGER PRIMARY KEY NOT NULL,
        mac_address VARCHAR(100),
        key VARCHAR(100),
        username VARCHAR(100),
        password VARCHAR(100),
        expire_date VARCHAR(100),
        dns VARCHAR(100),
        epg_url VARCHAR(100),
        title VARCHAR(100),
        url VARCHAR(100),
        type VARCHAR(100)
    )
");

// Excluir registro
if (isset($_GET["delete"])) {
    $id = intval($_GET["delete"]);
    $db->exec("DELETE FROM ibo WHERE id={$id}");
    $db->close();
    header("Location: users.php");
    exit;
}

include "includes/header.php";
?>

<!-- Modal de confirmação -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Confirmar Exclusão</h2>
            </div>
            <div class="modal-body">
                Tem certeza que deseja excluir este registro?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <a class="btn btn-danger btn-ok">Excluir</a>
            </div>
        </div>
    </div>
</div>

<main role="main" class="col-15 pt-4 px-5">
    <div class="row justify-text-center">
        <h2>Usuario Mac</h2>
        <div class="input-group mb-3">
            <a class="btn btn-success btn-icon-split" href="./users_create.php">
                <span class="icon text-white-50"><i class="fas fa-check"></i></span>
                <span class="text">Criar</span>
            </a>
            &nbsp;&nbsp;
    <div class="table-responsive">
        <table id="myTable" class="table table-striped table-sm">
            <thead class="text-primary">
                <tr>
                    <th>ID</th>
                    <th>Device ID</th>
                    <th>Device Key</th>
                    <th>Username</th>
                    <th>Expire Date</th>
                    <th>DNS / M3U</th>
                    <th>EPG</th>
                    <th>Title</th>
                    <th>Edit</th>
                    <th>Delete</th>
                </tr>
            </thead>
            <tbody class="text-primary">
                <?php
                $res = $db->query("SELECT * FROM ibo");
                while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
                    $iid = $row["id"];
                    $imac = $row["mac_address"];
                    $ikey = $row["key"];
                    $iexpire_date = $row["expire_date"];
                    $iusername = $row["dns"] ? $row["username"] : "listm3u-id{$row["id"]}";
                    $idns = $row["dns"] ?: $row["url"];
                    $iepg = $row["epg_url"];
                    $ititle = $row["title"];
                ?>
                <tr>
                    <td><?= htmlspecialchars($iid) ?></td>
                    <td><?= htmlspecialchars($imac) ?></td>
                    <td><?= htmlspecialchars($ikey) ?></td>
                    <td><?= htmlspecialchars($iusername) ?></td>
                    <td><?= htmlspecialchars($iexpire_date) ?></td>
                    <td><?= htmlspecialchars($idns) ?></td>
                    <td><?= htmlspecialchars($iepg) ?></td>
                    <td><?= htmlspecialchars($ititle) ?></td>
                    <td>
                        <a class="btn btn-icon" href="./users_update.php?update=<?= $iid ?>">
                            <i class="fa fa-rss" style="font-size:20px;color:blue"></i>
                        </a>
                    </td>
                    <td>
                        <a class="btn btn-icon" href="./users.php?delete=<?= $iid ?>">
                            <i class="fa fa-globe" style="font-size:20px;color:red"></i>
                        </a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</main>

<?php include "includes/footer.php"; ?>

<script>
$("#search").keyup(function () {
    var value = this.value.toLowerCase().trim();
    $("#myTable tbody tr").each(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
    });
});

$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>

</body>
</html>
