<?php
error_reporting(0);
header('Content-Type: application/json');

// Configuração do banco de dados MySQL
$servername = "localhost";
$dbname = "eaitv2";
$serverport = 3306;
$username = "eaitv2";
$password = 'eaitv12345';

// Conexão com MySQL
$dsn = "mysql:host=$servername;port=$serverport;dbname=$dbname;";
$connection = new PDO($dsn, $username, $password, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

// Pegando os dados da URL
$username_ = $_GET['username'];
$password_ = $_GET['password'];

// Consultando o DNS associado ao usuário
$stmt = $connection->prepare("SELECT * FROM `users` WHERE username_ = ? AND password = ?");
$stmt->bindParam(1, $username_);
$stmt->bindParam(2, $password_);
$stmt->execute();

$seller = 1; // Padrão, caso não encontre o usuário
if ($stmt->rowCount() > 0) {
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $seller = $row['member_id'];
    }
}

// Conectando ao banco SQLite para pegar o DNS
$db = new SQLite3('./api/.db.db');
$rows3 = $db->query("SELECT * FROM dns WHERE id = '$seller'");
$row3 = $rows3->fetchArray();

$portal_one = $row3['portal1'];  // Primeiro portal do usuário
$api_url = $portal_one;

// Função para obter os dados da API via GET
function getApiData($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);
   
    
    if (curl_errno($ch)) {
        echo json_encode(["error" => "Erro CURL: " . curl_error($ch)]);
        exit;
    }

    curl_close($ch);
    
    return json_decode($response, true);
}

// Chamadas para obter os filmes e categorias
$vod_streams_url = "{$api_url}/player_api.php?username={$username_}&password={$password_}&action=get_vod_streams";
$vod_categories_url = "{$api_url}/player_api.php?username={$username_}&password={$password_}&action=get_vod_categories";

$vod_streams = getApiData($vod_streams_url);
$vod_categories = getApiData($vod_categories_url);

// Verifica se os dados retornaram corretamente
if (!isset($vod_streams) || !isset($vod_categories)) {
    echo json_encode(["error" => "Erro ao obter os dados da API"]);
    exit;
}

// Criar um mapa de categorias [category_id => category_name]
$categories = [];
foreach ($vod_categories as $category) {
    $categories[$category["category_id"]] = $category["category_name"];
}

// Inicializa a resposta JSON
$response = ["movies" => []];

// Organiza os filmes no formato solicitado
foreach ($vod_streams as $movie) {
    $extension = $movie["container_extension"] ?? "mp4"; // Extensão do vídeo
    $category_id = $movie["category_id"] ?? "0"; // Pega o ID da categoria
    $language = $categories[$category_id] ?? "Desconhecido"; // Busca o nome da categoria pelo ID

    $response["movies"][] = [
        "id" => (int)$movie["stream_id"],
        "name" => $movie["name"],
        "language" => "Português",  // Agora o nome da categoria será o idioma
        "genre" => $language,  // Agora o nome da categoria será o idioma
      //  "genre" => $movie["genre"] ?? "Não especificado",
        "added" => (int)$movie["added"],
        "rating" => $movie["rating"] ?? "0",
        "rating_5based" => (float)$movie["rating_5based"] ?? 0,
        "description" => $movie["description"] ?? "Sem descrição disponível.",
        "stream_url" => "{$api_url}/movie/{$username_}/{$password_}/{$movie["stream_id"]}.{$extension}",
        "stream_icon" => $movie["stream_icon"] ?? "",
        "year" => $movie["year"] ?? "Desconhecido",
        "youtube_trailer" => $movie["youtube_trailer"] ?? ""
    ];
}

// Retorna a resposta JSON formatada
echo json_encode($response, JSON_PRETTY_PRINT);
?>