<?php
error_reporting(0);
header('Content-Type: application/json');

// Configuração do banco de dados MySQL
$servername = "localhost";
$dbname = "newp2p";
$serverport = 3306;
$username = "newp2p";
$password = '312680le';

// Conexão com MySQL
$dsn = "mysql:host=$servername;port=$serverport;dbname=$dbname;";
$connection = new PDO($dsn, $username, $password, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

// Pegando os dados da URL
$username_ = $_GET['username'];
$password_ = $_GET['password'];

// Consultando o DNS associado ao usuário
$stmt = $connection->prepare("SELECT * FROM `users` WHERE username_ = ? AND password = ?");
$stmt->bindParam(1, $username_);
$stmt->bindParam(2, $password_);
$stmt->execute();

$seller = 1; // Padrão, caso não encontre o usuário
if ($stmt->rowCount() > 0) {
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $seller = $row['member_id'];
    }
}

// Conectando ao banco SQLite para pegar o DNS
$db = new SQLite3('./api/.db.db');
$rows3 = $db->query("SELECT * FROM dns WHERE id = '$seller'");
$row3 = $rows3->fetchArray();

$portal_one = $row3['portal1'];  // Primeiro portal do usuário
$api_url = $portal_one;

// Função para obter os dados da API via GET
function getApiData($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        echo json_encode(["error" => "Erro CURL: " . curl_error($ch)]);
        exit;
    }

    curl_close($ch);
    
    return json_decode($response, true);
}

// URL para obter as séries
$series_streams_url = "{$api_url}/player_api.php?username={$username_}&password={$password_}&action=get_series";
$series_categories_url = "{$api_url}/player_api.php?username={$username_}&password={$password_}&action=get_series_categories";

// Requisição para as séries
$series_streams = getApiData($series_streams_url);
$series_categories = getApiData($series_categories_url);

// Verifica se os dados retornaram corretamente
if (!isset($series_streams) || !isset($series_categories)) {
    echo json_encode(["error" => "Erro ao obter os dados da API"]);
    exit;
}

// Criar um mapa de categorias [category_id => category_name]
$categories = [];
foreach ($series_categories as $category) {
    $categories[$category["category_id"]] = $category["category_name"];
}

// Inicializa a resposta JSON
$response = ["series" => []];

// Organiza as séries no formato solicitado
foreach ($series_streams as $series) {
    $category_id = $series["category_id"] ?? "0"; // Pega o ID da categoria
    $language = $categories[$category_id] ?? "Desconhecido"; // Busca o nome da categoria pelo ID

    $response["series"][] = [
        "id" => (int)$series["series_id"],
        "name" => $series["name"],
"language" => "Português",  // Agora o nome da categoria será o idioma
        "genre" => $language,
    //    "language" => $language,  // Agora o nome da categoria será o idioma
      //  "genre" => $series["genre"] ?? "Não especificado",
        "added" => (int)$series["last_modified"],
        "rating" => $series["rating"] ?? "0",
        "description" => $series["plot"] ?? "Sem descrição disponível.",
        "icon" => $series["cover"] ?? "",
        "seasons" => $series["seasons"] ?? [],
        "youtube_trailer" => $series["youtube_trailer"] ?? ""
    ];
}

// Retorna a resposta JSON formatada
echo json_encode($response, JSON_PRETTY_PRINT);
?>